from collections import namedtuple

prvky = {}
Prvek = namedtuple('prvek', 'A, ord, en, els, valency')

with open('prvky.1.txt') as f:
    for line in f:
        symbol, A, ord, en, els, valency = line.strip().split(';')
        prvky[symbol.strip('"')] = Prvek(
            A.strip(),
            ord.split(':')[-1].strip(),
            en.split(':')[-1].strip(),
            els.split(':')[-1].strip(),
            valency.split(':')[-1].strip()
        )

# seřazený výpis
for k,v in sorted(prvky.items(), key=lambda x: float(x[1].en)):
    print(k, v)
